/*
 * UART.h
 *
 *  Created on: Mar 23, 2015
 *      Author: Austin Riffle
 */

#ifndef UART_H_
#define UART_H_

#include <stdint.h>
#include "driverlib/sysctl.h"
#include "driverlib/uart.h"
#include "driverlib/pin_map.h"
#include "driverlib/gpio.h"
#include "inc/hw_memmap.h"
#include "globalDefs.h"

namespace uart
{
/***************************************************************************************/

class UartInterface
{
	const uint32_t uartRxGpioPin;
	const uint32_t uartTxGpioPin;
	const uint32_t uartRxPinNumber;
	const uint32_t uartTxPinNumber;
	const uint32_t uartBase;
	const uint32_t uartPortBase;
	const uint32_t uartPeripheral;
public:
	inline UartInterface() :
#ifdef LAUNCHPAD
		uartRxGpioPin(GPIO_PB0_U1RX), uartTxGpioPin(GPIO_PB1_U1TX), uartRxPinNumber(GPIO_PIN_0),
		uartTxPinNumber(GPIO_PIN_1), uartBase(UART1_BASE), uartPortBase(GPIO_PORTB_BASE),
		uartPeripheral(SYSCTL_PERIPH_UART1) {}
#elif CUSTOM_BOARD
		uartRxGpioPin(GPIO_PA0_U0RX), uartTxGpioPin(GPIO_PA1_U0TX), uartRxPinNumber(GPIO_PIN_0),
		uartTxPinNumber(GPIO_PIN_1), uartBase(UART0_BASE), uartPortBase(GPIO_PORTA_BASE),
		uartPeripheral(SYSCTL_PERIPH_UART0) {}
#endif
	inline ~UartInterface() {/*Nothing to do*/}
	//todo: if time, implement copy/assignment operators
	void begin(uint32_t baudRate);
	void write(uint8_t byte);
	bool available();
	uint8_t read();
};

/***************************************************************************************/
}
#endif /* UART_H_ */
